/* Copyright (C) 2012-2018 RealVNC Ltd. All Rights Reserved.
 * 
 * This is sample code intended to demonstrate part of the
 * VNC Mobile Solution SDK. It is not intended as a production-ready
 * component.
 */

#ifndef UUID_507b2de9_9267_d481_3c8b_f921978f96c1
#define UUID_507b2de9_9267_d481_3c8b_f921978f96c1

#include <stdexcept>

namespace vncdiscovery
{

/**
 * Exception thrown by discovery code. The exception should be caught
 * before by the plug-in that throws it.
 */
class DiscoveryException : public std::runtime_error
{
public:
  DiscoveryException(const char* msg, int error)
    : std::runtime_error(msg),
      errorCode(error)
  { }

  int errorCode;
};

} // namespace vncdiscovery

#endif /* !defined(UUID_507b2de9_9267_d481_3c8b_f921978f96c1) */

